/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.network.toserver;

import de.unhappycodings.quarry.common.blockentity.QuarryBlockEntity;
import de.unhappycodings.quarry.common.network.PacketHandler;
import de.unhappycodings.quarry.common.network.base.IPacket;
import de.unhappycodings.quarry.common.network.toclient.QuarryClientIntPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class QuarryIntPacket
implements IPacket {
    private final BlockPos pos;
    private final byte add;
    private final String type;

    public QuarryIntPacket(BlockPos pos, byte add, String type) {
        this.pos = pos;
        this.add = add;
        this.type = type;
    }

    public static QuarryIntPacket decode(FriendlyByteBuf buffer) {
        return new QuarryIntPacket(buffer.m_130135_(), buffer.readByte(), buffer.m_130277_());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        BlockEntity machine = player.m_20193_().m_7702_(this.pos);
        if (!(machine instanceof QuarryBlockEntity)) {
            return;
        }
        QuarryBlockEntity blockEntity = (QuarryBlockEntity)machine;
        if (this.type.contains("speed")) {
            if (this.add != 0) {
                int newSpeed = blockEntity.getSpeed() + this.add;
                if (newSpeed >= 0 && newSpeed <= 3) {
                    blockEntity.setSpeed(newSpeed);
                    PacketHandler.sendToClient(new QuarryClientIntPacket(machine.m_58899_(), newSpeed, "speed"), player);
                }
            } else {
                PacketHandler.sendToClient(new QuarryClientIntPacket(machine.m_58899_(), blockEntity.getSpeed(), "speed"), player);
            }
        } else if (this.type.contains("eject")) {
            if (this.add != 0) {
                int newEject = blockEntity.getEject() + this.add;
                if (newEject >= 0 && newEject <= 3) {
                    blockEntity.setEject(newEject);
                    PacketHandler.sendToClient(new QuarryClientIntPacket(machine.m_58899_(), newEject, "eject"), player);
                } else {
                    blockEntity.setEject(0);
                    PacketHandler.sendToClient(new QuarryClientIntPacket(machine.m_58899_(), 0, "eject"), player);
                }
            } else {
                PacketHandler.sendToClient(new QuarryClientIntPacket(machine.m_58899_(), blockEntity.getEject(), "eject"), player);
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeByte((int)this.add);
        buffer.m_130070_(this.type);
    }
}

